/// @addtogroup unifexp
/// @{

/////////////////////////////////////////////////////////////////////////////
///
/// @file rounding.h
///
/// This file contains the definition of a class for rounding operations
/// which uses the BOOST library.
///
/// @author Pawel Pilarczyk
///
/////////////////////////////////////////////////////////////////////////////

// Copyright (C) 2007 by Pawel Pilarczyk.
//
// This file is part of my research program package.  This is free software;
// you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation;
// either version 2 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this software; see the file "license.txt".  If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.

// Started on July 10, 2007. Last revision: July 10, 2007.

#ifndef _rounding_h_
#define _rounding_h_

// BOOST (this header must be included first)
#include "boost/numeric/interval.hpp"

#include <utility>
#include <iostream>


namespace unifexp {

// --------------------------------------------------
// -------------- rounding operations ---------------
// --------------------------------------------------

/// A class for rounding operations which uses the BOOST library.
template <class numType>
class tRounding
{
public:
/// This is an internal macro of the class template "tRounding"
/// which defines arithmetic operations using the operations
/// available in the BOOST library.
#define DEFOP(WHAT) \
	static inline numType WHAT (const numType &x, const numType &y) \
	{ \
		numType result = Rounding. WHAT (x, y); \
		Rounding. to_nearest (); \
		return result; \
	}

	DEFOP(add_down)
	DEFOP(add_up)
	DEFOP(sub_down)
	DEFOP(sub_up)
	DEFOP(mul_down)
	DEFOP(mul_up)
	DEFOP(div_down)
	DEFOP(div_up)

#undef DEFOP

/*	numType add_down (const numType &x, const numType &y) const
	{
		numType result = Rounding. add_down (x, y);
		Rounding. to_nearest ();
		return result;
	}
*/

private:
	/// This is an object from the BOOST library which contains
	/// the definitions of arithmetic operations with correct rounding.
	static boost::numeric::interval_lib::rounded_arith_std<numType>
		Rounding;
}; /* class tRounding */

// --------------------------------------------------

template <class numType>
boost::numeric::interval_lib::rounded_arith_std<numType>
	tRounding<numType>::Rounding;

// --------------------------------------------------


} // namespace unifexp

#endif // _rounding_h_

/// @}

