/// @addtogroup unifexp
/// @{

/////////////////////////////////////////////////////////////////////////////
///
/// @file intvcapd.h
///
/// This file contains some definitions necessary to use intervals
/// from the CAPD library.
/// Please, note that in the most of the code, BOOST intervals are used.
/// However, one may prefer to use the CAPD intervals occassionally,
/// because of the additional functions (sin, cos, log, exp) defined there.
///
/// @author Pawel Pilarczyk
///
/////////////////////////////////////////////////////////////////////////////

// Copyright (C) 2013 by Pawel Pilarczyk.
//
// This file is part of my research program package.  This is free software;
// you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation;
// either version 2 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this software; see the file "license.txt".  If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.

// Started on February 3, 2013. Last revision: February 3, 2013.

#ifndef _intvcapd_h_
#define _intvcapd_h_

#include "capd/intervals/lib.h"
#ifndef __USE_FILIB__
#include "capd/rounding/DoubleRounding.h"
#endif


namespace unifexp {

// --------------------------------------------------
// ------------- intervals and rounding -------------
// --------------------------------------------------

/// The type of an interval (from the CAPD library 2.9/3.0 beta).
typedef capd::DInterval IntervalType;

/// Resets the rounding switches of the processor
/// and sets rounding mode to the default one (to the nearest).
/// It is necessary in some cases, e.g., if the CAPD leaves
/// incorrect rounding mode after doing some interval operations.
/// If the "filib" interval library is used then this function does nothing.
inline void resetRounding ()
{
#ifndef __USE_FILIB__
	capd::rounding::DoubleRounding::roundNearest ();
#endif
	return;
} /* resetRounding */


} // namespace unifexp

#endif // _intvcapd_h_

/// @}

