/////////////////////////////////////////////////////////////////////////////
///
/// \file
///
/// The main page for the source code documentation.
///
/////////////////////////////////////////////////////////////////////////////
/**

\mainpage


\section intro Introduction

This software is developed within the framework of the
<a href="http://www.pawelpilarczyk.com/cohomology/">Computational
Cohomology</a> project.
It is aimed at constructing the chain contraction
of a cellular complex, and using this means to compute
the homology, cohomology, and related operations
on cubical or simplicial complexes.
This software is currently under development,
and a limited number of features are available at this time.
In this version, the ring of coefficients is assumed
to be the integers modulo 2, which best reflects
the combinatorial nature of the approach.


\section compilation Compilation

The compilation of the library and the programs is quite intuitive.
In the directory into which the source code has been unpacked,
one has to run the command <em>make</em>.
Since this software requires
the <a href="http://chomp.rutgers.edu/">CHomP library</a>,
it must be downloaded and compiled first,
and the path to where it is located must be corrected
in the <em>makefile</em> if necessary.

In Linux all the necessary utilities
should be present in the system by default
(the GNU C++ compiler and the GNU make),
but in Windows one should install them first (e.g. from the
<a href="http://www.bloodshed.net/dev/devcpp.html">Dev-C++</a>
distribution).
For convenience, pre-compiled binary programs for some systems
may be provided at the project website.


\section library Software Library

The main part of this software is provided in terms
of a C++ library, programmed as templates of classes
and functions for optimal flexibility (so-called
generic programming technique).
All the header files of which the programming library consists
are located in the subdirectory <em>chaincon</em>.


\section programs Programs

The programs included in this package constitute a simple interface
to the main functions of the C++ programming library.
These are command-line utilities, to be run from a text terminal window
(a.k.a. command prompt).
Each program displays brief usage information
when called without arguments.
The programs read data from files in the text format
and display all the results to the output stream,
which is the screen by default,
but can also be logged to a file using the "--log filename"
command-line argument.


\section data Data Formats

The classes defined in the software library
are equipped with reading and writing operators
that allows the conversion of the data to and from
human-readable and intuitive text format.
This format is in most part compatible
with the CHomP software, and is described below.
In particular, any line beginning with the semicolon ';'
is treated as a comment and is skipped.

<b>Cubical complexes</b> are defined by listing all the cubical cells
line by line, one cell per line.
Faces of cells must be either omitted,
or listed later than the corresponding cells.
A cubical cell is defined as the Cartesian product
of intervals of length 1 or 0 (degenerate ones),
e.g. <em>[1,2]x[0]x[-3,-2]x[3]</em> (note the brackets,
the commas, the letter 'x', and the way of defining degenerate intervals).
If the dimension of the cell equals the dimension
of the embedding space then it can be defined
by listing the minimal coordinates of the vertices,
e.g. <em>(1,0,-3,3)</em> (note the parentheses and the commas).

<b>Simplicial complexes</b> are defined by listing all the simplices
line by line, one simplex per line.
Faces of simplices must be either omitted,
or listed later than the corresponding simplices.
A simplex is defined as a comma-separated list of numbers of its vertices,
e.g. <em>(1,3,18)</em>.

Several examples (see below) illustrate how these data formats
can be actually used in practice, and also how the provided
command-line programs can be used.


\section examples Examples

There are some examples (to be downloaded separately)
which may be helpful if one wants to quickly learn
how the command-line programs should be used.
Running these examples also gives some hint on the effectiveness
of the software, and shows what kind of information it computes.
The examples were prepared in such a way that a variety of features
can be illustrated.
Each example has a description in a text file,
and a shell script (a.k.a. batch file)
which runs a few commands and displays brief explanations of all the steps.
A GUI Python script <em>examples.py</em> has been prepared,
which can be used to browse the examples
prepared for this piece of software.
The list of examples is continually expanding.
Contributions of new examples or suggestions are welcome.


\section license License

This software package is published under the terms
of the <a href="http://www.gnu.org/licenses/gpl.html">GNU
General Public License, version 3</a>.


\section remark Remarks

This documentation is currently under construction.
Although many classes and functions already have their descriptions,
I am aware of the fact that these descriptions are not as detailed
as the user might wish to have. Therefore, this documentation
has been generated in such a way that it includes the entire source code
which sould be consulted if in doubt. The code has many additional
comments which shed light on what it actually does.

I am still working on making this documentation more informative
and complete, but it takes a lot of time.
Therefore, I apologize for any inconvenience caused by the incomplete
documentation and I invite to browse the source code instead,
or ask me specific questions by email.

Pawel Pilarczyk

**/
