/////////////////////////////////////////////////////////////////////////////
///
/// \file
///
/// Hashing keys for std::string.
///
/////////////////////////////////////////////////////////////////////////////

// Copyright (C) 2009-2011 by Pawel Pilarczyk.
//
// This file is part of my research software package. This is free software:
// you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this software; see the file "license.txt". If not,
// please, see <http://www.gnu.org/licenses/>.

// Started on March 24, 2009. Last revision: March 4, 2011.


#ifndef _CHAINCON_STRINGHASH_H_
#define _CHAINCON_STRINGHASH_H_


// include some standard C++ header files
#include <string>

// include selected header files from the CHomP library
#include "chomp/system/config.h"


// --------------------------------------------------

/// Creates a generic hashing key no. 1 for the standard string type,
/// to be used in a hashed set.
inline int_t hashkey1 (const std::string &s)
{
	int_t len = s. size ();
	if (len == 0)
		return 0;
	else if (len == 1)
		return static_cast<int_t> (s [0]) << 4;
	else if (len == 2)
	{
		return ((static_cast<int_t> (s [0]) & 0x5555u) << 12) ^
			((static_cast<int_t> (s [1]) & 0xAAAAu));
	}
	else
	{
		return ((static_cast<int_t> (s [0]) & 0x9249u) << 16) ^
			((static_cast<int_t> (s [len >> 1]) & 0x2492u)
			<< 8) ^
			((static_cast<int_t> (s [len - 1]) & 0x4924u)) ^
			(len << 12);
	}
} /* hashkey1 */

/// Creates a generic hashing key no. 1 for the standard string type,
/// to be used in a hashed set.
inline int_t hashkey2 (const std::string &s)
{
	int_t len = s. size ();
	if (len == 0)
		return 0;
	else if (len == 1)
		return static_cast<int_t> (s [0]) << 7;
	else if (len == 2)
	{
		return ((static_cast<int_t> (s [0]) & 0xAAAAu) << 5) ^
			((static_cast<int_t> (s [1]) & 0x5555u) << 15);
	}
	else
	{
		return ((static_cast<int_t> (s [len - 1]) & 0xC30Cu) << 15) ^
			((static_cast<int_t> (s [0]) & 0x30C3u) << 7) ^
			((static_cast<int_t> (s [len >> 1]) & 0x0C30u)
			<< 1) ^
			(len << 9);
	}
} /* hashkey2 */


#endif // _CHAINCON_STRINGHASH_H_

