/////////////////////////////////////////////////////////////////////////////
///
/// \file
///
/// A pair of elements.
///
/////////////////////////////////////////////////////////////////////////////

// Copyright (C) 2009-2011 by Pawel Pilarczyk.
//
// This file is part of my research software package. This is free software:
// you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this software; see the file "license.txt". If not,
// please, see <http://www.gnu.org/licenses/>.

// Started on March 24, 2009. Last revision: March 6, 2011.


#ifndef _CHAINCON_PAIR_H_
#define _CHAINCON_PAIR_H_


// include some standard C++ header files
#include <istream>
#include <ostream>
#include <algorithm>
#include <vector>

// include selected header files from the CHomP library
#include "chomp/system/config.h"


// --------------------------------------------------
// --------------- a pair of elements ---------------
// --------------------------------------------------

/// A pair of elements of two (possibly different) types.
template <class LeftT, class RightT>
class tPair
{
public:
	/// The default constructor of a pair.
	tPair () {}

	/// The constructor of a pair composed of the two given elements.
	tPair (const LeftT &leftElement, const RightT &rightElement):
		left (leftElement), right (rightElement) {}

	/// The first element of the pair.
	LeftT left;

	/// The second element of the pair.
	RightT right;

}; /* class tPair */

// --------------------------------------------------

/// Generates a hashing key no. 1 for a general pair of elements,
/// based on hashing keys of the elements.
/// This key is to be used in a hashed set.
template <class LeftT, class RightT>
inline int_t hashkey1 (const tPair<LeftT,RightT> &p)
{
	return hashkey1 (p. left) ^ hashkey1 (p. right);
} /* hashkey1 */

/// Generates a hashing key no. 2 for a general pair of elements,
/// based on hashing keys of the elements.
/// This key is to be used in a hashed set.
template <class LeftT, class RightT>
inline int_t hashkey2 (const tPair<LeftT,RightT> &p)
{
	return hashkey2 (p. left) ^ hashkey2 (p. right);
} /* hashkey2 */

/// Operator == for checking whether two pairs are equal.
template <class LeftT, class RightT>
inline bool operator == (const tPair<LeftT,RightT> &p1,
	const tPair<LeftT,RightT> &p2)
{
	return ((p1. left == p2. left) && (p1. right == p2. right));
} /* operator == */


#endif // _CHAINCON_PAIR_H_

