/////////////////////////////////////////////////////////////////////////////
///
/// \file
///
/// Homology gradient vector field computation: An interface to all the
/// algorithms available in this package.
///
/////////////////////////////////////////////////////////////////////////////

// Copyright (C) 2009-2011 by Pawel Pilarczyk.
//
// This file is part of my research software package. This is free software:
// you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this software; see the file "license.txt". If not,
// please, see <http://www.gnu.org/licenses/>.

// Started on March 24, 2009. Last revision: April 3, 2011.


#ifndef _CHAINCON_HOMGVF_H_
#define _CHAINCON_HOMGVF_H_


// include relevant local header files
#include "chaincon/homgvf0.h"
#include "chaincon/homgvf1.h"
#include "chaincon/homgvf2.h"
#include "chaincon/homgvf3.h"


// --------------------------------------------------
// ------------------ Homology GVF ------------------
// --------------------------------------------------

/// Computes the homology gradient vector field for a given
/// filtered finite cell complex "K".
/// This function is an interface to the various algorithms
/// available in this package, numbered from 0 to 3.
/// Cells that represent homology generators are appended to the vector "H".
/// The projection map "pi", the inclusion from "H" to the complex "K",
/// and the homology gradient vector field "phi"
/// are assumed to be initially zero and are constructed.
template <class CellT, class CellArray1, class CellArray2>
void homologyGVF (const CellArray1 &K, CellArray2 &H,
	tCombLinMap<CellT,CellT> &pi,
	tCombLinMap<CellT,CellT> &incl,
	tCombLinMap<CellT,CellT> &phi, int version)
{
	switch (version)
	{
	case 0:
		homologyGVF0 (K, H, pi, incl, phi);
		break;
	case 1:
		homologyGVF1 (K, H, pi, incl, phi);
		break;
	case 2:
		homologyGVF2 (K, H, pi, incl, phi);
		break;
	case 3:
		homologyGVF3 (K, H, pi, incl, phi);
		break;
	default:
		throw "Wrong homology algorithm requested.";
	}
	return;
} /* homologyGVF */


#endif // _CHAINCON_HOMGVF_H_

