/////////////////////////////////////////////////////////////////////////////
///
/// \file
///
/// The decision on whether the empty cell should be used as a valid cell
/// of dimension -1.
///
/////////////////////////////////////////////////////////////////////////////

// Copyright (C) 2009-2011 by Pawel Pilarczyk.
//
// This file is part of my research software package. This is free software:
// you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this software; see the file "license.txt". If not,
// please, see <http://www.gnu.org/licenses/>.

// Started on March 24, 2009. Last revision: March 4, 2011.


#ifndef _CHAINCON_EMPTYCELL_H_
#define _CHAINCON_EMPTYCELL_H_


// --------------------------------------------------
// ------------------- empty cell -------------------
// --------------------------------------------------

/// Don't use the empty cell.
/// This symbol must be defined in order to suppress
/// the usage of the empty cell (of dimension -1)
/// in the boundaries of cells.
/// Otherwise, the empty cell is considered a valid cell,
/// and, as a result, reduced homology will be computed
/// instead of plain homology.
/// Note: The presence of the empty cell may cause problems while interfacint
/// with the CHomP library, which assumes no empty cell presence.
#define NO_EMPTY_CELL


#endif // _CHAINCON_EMPTYCELL_H_

