/////////////////////////////////////////////////////////////////////////////
///
/// \file
///
/// A simplicial version of the Alexander-Whitney diagonal.
///
/////////////////////////////////////////////////////////////////////////////

// Copyright (C) 2009-2011 by Pawel Pilarczyk.
//
// This file is part of my research software package. This is free software:
// you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this software; see the file "license.txt". If not,
// please, see <http://www.gnu.org/licenses/>.

// Started on March 24, 2009. Last revision: March 6, 2011.


#ifndef _CHAINCON_AWDIAGSIM_H_
#define _CHAINCON_AWDIAGSIM_H_


// include some standard C++ header files
#include <istream>
#include <ostream>

// include selected header files from the CHomP library
#include "chomp/system/config.h"

// include relevant local header files
#include "chaincon/simplex.h"
#include "chaincon/combtensor.h"


// --------------------------------------------------
// ------------------ AW diagonal -------------------
// --------------------------------------------------

/// Computes the Alexander-Whitney diagonal of a simplex.
template <class VertexT>
inline tCombTensor<tSimplex<VertexT> > AWdiagonal
	(const tSimplex<VertexT> &s)
{
	tCombTensor<tSimplex<VertexT> > tensor;
	int dim = s. dim ();
	VertexT *left = new VertexT [dim + 1];
	VertexT *right = new VertexT [dim + 1];
	for (int n = 0; n <= dim; ++ n)
	{
		for (int i = 0; i <= n; ++ i)
			left [i] = s [i];
		for (int i = n; i <= dim; ++ i)
			right [i - n] = s [i];
		tensor. add (tSimplex<VertexT> (n, left),
			tSimplex<VertexT> (dim - n, right));
	}
	delete [] right;
	delete [] left;
	return tensor;
} /* AWdiagonal */


#endif // _CHAINCON_AWDIAGSIM_H_

