/////////////////////////////////////////////////////////////////////////////
///
/// \file
///
/// Alexander-Whitney diagonal of a chain.
///
/////////////////////////////////////////////////////////////////////////////

// Copyright (C) 2009-2011 by Pawel Pilarczyk.
//
// This file is part of my research software package. This is free software:
// you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this software; see the file "license.txt". If not,
// please, see <http://www.gnu.org/licenses/>.

// Started on March 24, 2009. Last revision: March 6, 2011.


#ifndef _CHAINCON_AWDIAG_H_
#define _CHAINCON_AWDIAG_H_


// include some standard C++ header files
#include <istream>
#include <ostream>

// include selected header files from the CHomP library
#include "chomp/system/config.h"

// include relevant local header files
#include "chaincon/combtensor.h"


// --------------------------------------------------
// ------------------ AW diagonal -------------------
// --------------------------------------------------

/// Computes the Alexander-Whitney diagonal of a chain,
/// using the procedure defined for individual cells.
template <class CellT>
inline tCombTensor<CellT> AWdiagonal (const tCombChain<CellT> &ch)
{
	tCombTensor<CellT> tensor;
	int_t size = ch. size ();
	for (int_t n = 0; n < size; ++ n)
		tensor. add (AWdiagonal (ch [n]));
	return tensor;
} /* AWdiagonal */


#endif // _CHAINCON_AWDIAG_H_

